<?php
// DONT MODIFY BELOW //

// Definindo o caminho do arquivo JSON
$json_file = "./includes/dns/dns.json";

// Verificando se o diretório existe; caso contrário, criando-o
if (!is_dir('./includes/dns')) {
    mkdir('./includes/dns', 0775, true);
}

// Estrutura inicial padrão (Caso o arquivo não exista)
$default_json = [
    "sitename" => "Web Player",
    "username" => "admin",
    "password" => "admin",
    "default_color" => "black",
    "dns_number" => "no",
    "server1_name" => "", "server1" => "",
    "server2_name" => "", "server2" => "",
    "server3_name" => "", "server3" => "",
    "server4_name" => "", "server4" => "",
    "server5_name" => "", "server5" => "",
    "server6_name" => "", "server6" => ""
];

// Verificando a existência do arquivo JSON e criando-o se necessário
if (!file_exists($json_file)) {
    // Salva com PRETTY_PRINT para ser legível e UNESCAPED_SLASHES para URLs ficarem limpas
    file_put_contents($json_file, json_encode($default_json, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
    $json = $default_json;
} else {
    $jsondata = file_get_contents($json_file);
    $json = json_decode($jsondata, true);
    
    // Se o arquivo existir mas estiver corrompido, carrega o padrão
    if ($json === null) {
        $json = $default_json;
    }
}

// Extração de variáveis para uso no sistema
$sitename      = $json['sitename'] ?? 'Web Player';
$adminU        = $json['username'] ?? 'admin';
$adminP        = $json['password'] ?? 'admin';
$default_color = $json['default_color'] ?? 'black';

/**
 * FUNÇÃO PARA SALVAR ALTERAÇÕES
 * Use esta função sempre que precisar atualizar uma DNS
 */
function updateDns($key, $value) {
    global $json_file, $json;
    $json[$key] = $value;
    return file_put_contents($json_file, json_encode($json, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
}

// Verificação de HTTPS e Diretórios
if ((isset($_SERVER['HTTPS']) && ($_SERVER['HTTPS'] == 'on' || $_SERVER['HTTPS'] == 1)) ||
    (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] == 'https')) {
    $protocol = 'https://';
} else {
    $protocol = 'http://';
}

$basedir = $protocol . $_SERVER['HTTP_HOST'] . substr($_SERVER['REQUEST_URI'], 0, strrpos($_SERVER['REQUEST_URI'], '/'));
$get_dir = $basedir;
?>